/// PlayerUpdate()

// Get inputs
jumpKeyDown		= keyboard_check(keyJump);
jumpKeyPressed	= keyboard_check_pressed(keyJump);
rightKeyDown	= keyboard_check(keyRight);
leftKeyDown		= keyboard_check(keyLeft);

if inputCooldown > 0 then inputCooldown -= 1;
else {
	shootKeyDown	= keyboard_check(keyShoot);
}

// ----------------------------------------------------------------------------
// Horizontal movement with collision checks
if (rightKeyDown and !place_meeting(x + 1, y, oCollision))
{
	if (xSpeed < maxRunSpeed) {
		xSpeed += accel;
	}
	image_xscale = 1;
}
else if (leftKeyDown and !place_meeting(x - 1, y, oCollision))
{
	if (xSpeed > -maxRunSpeed) {
		xSpeed -= accel;
	}
	image_xscale = -1;
}

// Apply friction if no keys are pressed
if (xSpeed != 0 and !rightKeyDown and !leftKeyDown)
{
	xSpeed -= sign(xSpeed) * frict;
}

// Pixel perfect collision
if (!place_meeting(x + xSpeed, y, oCollision)) {
	x += xSpeed;
} else {
	var xSpeedSign = sign(xSpeed);
	while( !place_meeting(x + xSpeedSign, y, oCollision)) {
		x += xSpeedSign;
	}
	xSpeed = 0;
}

// ----------------------------------------------------------------------------

// State machine for player's vertical state
switch(vertState) {
	case verticalState.onGround:
		PlayerStateOnGround();
		break;
	case verticalState.falling:
		PlayerStateFalling();
		break;
	case verticalState.jumping:
		PlayerStateJumping();
		break;
	case verticalState.flying:
		PlayerStateFlying();
		break;
}

// Vertical movement with collision checks
if (vertState != verticalState.onGround) {
	if (ySpeed < maxFallSpeed)
		ySpeed += weight;
}

if (!place_meeting(x, y + ySpeed, oCollision)) {
	y += ySpeed;
} else {
	move_contact_solid(point_direction(x, y, x, y + ySpeed), maxFallSpeed);
	ySpeed = 0;
}

// Warp
WarpHorizontaly();

// immunity cooldown
if (immune > 0) immune -= 1;

// Recharge the fuel if we are not flying
with oPlayerStats {
	if (currentFuel < maxFuel and other.vertState != verticalState.flying)
		currentFuel += fuelChargeRate;
}

// move the audio listener
//if (xSpeed != 0 or ySpeed != 0)
//	audio_listener_position(x, y, 0);













